// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_
#define V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_

// IWYU pragma: private "src/roots/static-roots.h"

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/roots/roots.h"

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kUndefinedValue = 0x11;
  static constexpr Tagged_t kNullValue = 0x2d;
  static constexpr Tagged_t kempty_string = 0x49;
  static constexpr Tagged_t kFalseValue = 0x55;
  static constexpr Tagged_t kTrueValue = 0x71;
  static constexpr Tagged_t kSharedSeqTwoByteStringMap = 0x8d;
  static constexpr Tagged_t kSharedSeqOneByteStringMap = 0xb5;
  static constexpr Tagged_t kSeqTwoByteStringMap = 0xdd;
  static constexpr Tagged_t kSeqOneByteStringMap = 0x105;
  static constexpr Tagged_t kInternalizedTwoByteStringMap = 0x12d;
  static constexpr Tagged_t kInternalizedOneByteStringMap = 0x155;
  static constexpr Tagged_t kExternalInternalizedTwoByteStringMap = 0x17d;
  static constexpr Tagged_t kExternalInternalizedOneByteStringMap = 0x1a5;
  static constexpr Tagged_t kUncachedExternalInternalizedTwoByteStringMap =
      0x1cd;
  static constexpr Tagged_t kUncachedExternalInternalizedOneByteStringMap =
      0x1f5;
  static constexpr Tagged_t kUncachedExternalTwoByteStringMap = 0x21d;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x245;
  static constexpr Tagged_t kSharedUncachedExternalTwoByteStringMap = 0x26d;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x295;
  static constexpr Tagged_t kSharedExternalTwoByteStringMap = 0x2bd;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x2e5;
  static constexpr Tagged_t kExternalTwoByteStringMap = 0x30d;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x335;
  static constexpr Tagged_t kConsTwoByteStringMap = 0x35d;
  static constexpr Tagged_t kConsOneByteStringMap = 0x385;
  static constexpr Tagged_t kSlicedTwoByteStringMap = 0x3ad;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x3d5;
  static constexpr Tagged_t kThinTwoByteStringMap = 0x3fd;
  static constexpr Tagged_t kThinOneByteStringMap = 0x425;
  static constexpr Tagged_t kSymbolMap = 0x44d;
  static constexpr Tagged_t kMetaMap = 0x475;
  static constexpr Tagged_t kUndefinedMap = 0x49d;
  static constexpr Tagged_t kNullMap = 0x4c5;
  static constexpr Tagged_t kBooleanMap = 0x4ed;
  static constexpr Tagged_t kHeapNumberMap = 0x515;
  static constexpr Tagged_t kBigIntMap = 0x53d;
  static constexpr Tagged_t kFreeSpaceMap = 0x565;
  static constexpr Tagged_t kOnePointerFillerMap = 0x58d;
  static constexpr Tagged_t kTwoPointerFillerMap = 0x5b5;
  static constexpr Tagged_t kFixedArrayMap = 0x5dd;
  static constexpr Tagged_t kTrustedFixedArrayMap = 0x605;
  static constexpr Tagged_t kProtectedFixedArrayMap = 0x62d;
  static constexpr Tagged_t kWeakFixedArrayMap = 0x655;
  static constexpr Tagged_t kTrustedWeakFixedArrayMap = 0x67d;
  static constexpr Tagged_t kProtectedWeakFixedArrayMap = 0x6a5;
  static constexpr Tagged_t kWeakArrayListMap = 0x6cd;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x6f5;
  static constexpr Tagged_t kDescriptorArrayMap = 0x71d;
  static constexpr Tagged_t kHoleMap = 0x745;
  static constexpr Tagged_t kCallSiteInfoMap = 0x76d;
  static constexpr Tagged_t kEnumCacheMap = 0x795;
  static constexpr Tagged_t kEmptyFixedArray = 0x7bd;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x7c5;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x7cd;
  static constexpr Tagged_t kEmptyEnumCache = 0x7d9;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x7e5;
  static constexpr Tagged_t kScopeInfoMap = 0x7f9;
  static constexpr Tagged_t kModuleInfoMap = 0x821;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x849;
  static constexpr Tagged_t kFeedbackVectorMap = 0x871;
  static constexpr Tagged_t kForeignMap = 0x899;
  static constexpr Tagged_t kTrustedForeignMap = 0x8c1;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x8e9;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x911;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x939;
  static constexpr Tagged_t kByteArrayMap = 0x961;
  static constexpr Tagged_t kTrustedByteArrayMap = 0x989;
  static constexpr Tagged_t kBytecodeArrayMap = 0x9b1;
  static constexpr Tagged_t kPropertyArrayMap = 0x9d9;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0xa01;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0xa29;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0xa51;
  static constexpr Tagged_t kInstructionStreamMap = 0xa79;
  static constexpr Tagged_t kCellMap = 0xaa1;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xac9;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xad1;
  static constexpr Tagged_t kNoClosuresCellMap = 0xaf9;
  static constexpr Tagged_t kOneClosureCellMap = 0xb21;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb49;
  static constexpr Tagged_t kTransitionArrayMap = 0xb71;
  static constexpr Tagged_t kHashTableMap = 0xb99;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xbc1;
  static constexpr Tagged_t kNameDictionaryMap = 0xbe9;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xc11;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xc39;
  static constexpr Tagged_t kNumberDictionaryMap = 0xc61;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xc89;
  static constexpr Tagged_t kArrayListMap = 0xcb1;
  static constexpr Tagged_t kAccessorInfoMap = 0xcd9;
  static constexpr Tagged_t kInterceptorInfoMap = 0xd01;
  static constexpr Tagged_t kPreparseDataMap = 0xd29;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xd51;
  static constexpr Tagged_t kCodeMap = 0xd79;
  static constexpr Tagged_t kHashSeed = 0xda1;
  static constexpr Tagged_t kprototype_string = 0xdc9;
  static constexpr Tagged_t kname_string = 0xde1;
  static constexpr Tagged_t klength_string = 0xdf1;
  static constexpr Tagged_t kenumerable_string = 0xe05;
  static constexpr Tagged_t kconfigurable_string = 0xe1d;
  static constexpr Tagged_t kvalue_string = 0xe35;
  static constexpr Tagged_t kwritable_string = 0xe49;
  static constexpr Tagged_t knot_mapped_symbol = 0xe5d;
  static constexpr Tagged_t kuninitialized_symbol = 0xe6d;
  static constexpr Tagged_t kmegamorphic_symbol = 0xe7d;
  static constexpr Tagged_t kelements_transition_symbol = 0xe8d;
  static constexpr Tagged_t kmega_dom_symbol = 0xe9d;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xead;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xed9;
  static constexpr Tagged_t kEmptyByteArray = 0xef1;
  static constexpr Tagged_t kEmptyScopeInfo = 0xef9;
  static constexpr Tagged_t kEmptyPropertyArray = 0xf11;
  static constexpr Tagged_t kMinusZeroValue = 0xf19;
  static constexpr Tagged_t kNanValue = 0xf25;
  static constexpr Tagged_t kUndefinedNanValue = 0xf31;
  static constexpr Tagged_t kHoleNanValue = 0xf3d;
  static constexpr Tagged_t kInfinityValue = 0xf49;
  static constexpr Tagged_t kMinusInfinityValue = 0xf55;
  static constexpr Tagged_t kMaxSafeInteger = 0xf61;
  static constexpr Tagged_t kMaxUInt32 = 0xf6d;
  static constexpr Tagged_t kSmiMinValue = 0xf79;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xf85;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xf91;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0xfb9;
  static constexpr Tagged_t kCallableTaskMap = 0xfe1;
  static constexpr Tagged_t kCallbackTaskMap = 0x1009;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0x1031;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x1059;
  static constexpr Tagged_t kAccessorPairMap = 0x1081;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x10a9;
  static constexpr Tagged_t kAllocationMementoMap = 0x10d1;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x10f9;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x1121;
  static constexpr Tagged_t kBreakPointMap = 0x1149;
  static constexpr Tagged_t kBreakPointInfoMap = 0x1171;
  static constexpr Tagged_t kBytecodeWrapperMap = 0x1199;
  static constexpr Tagged_t kClassBoilerplateMap = 0x11c1;
  static constexpr Tagged_t kClassPositionsMap = 0x11e9;
  static constexpr Tagged_t kCodeWrapperMap = 0x1211;
  static constexpr Tagged_t kDebugInfoMap = 0x1239;
  static constexpr Tagged_t kErrorStackDataMap = 0x1261;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x1289;
  static constexpr Tagged_t kModuleRequestMap = 0x12b1;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x12d9;
  static constexpr Tagged_t kPromiseReactionMap = 0x1301;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x1329;
  static constexpr Tagged_t kPrototypeInfoMap = 0x1351;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x1379;
  static constexpr Tagged_t kRegExpDataWrapperMap = 0x13a1;
  static constexpr Tagged_t kScriptMap = 0x13c9;
  static constexpr Tagged_t kScriptOrModuleMap = 0x13f1;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x1419;
  static constexpr Tagged_t kStackFrameInfoMap = 0x1441;
  static constexpr Tagged_t kStackTraceInfoMap = 0x1469;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x1491;
  static constexpr Tagged_t kTuple2Map = 0x14b9;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x14e1;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x1509;
  static constexpr Tagged_t kLoadHandler1Map = 0x1531;
  static constexpr Tagged_t kLoadHandler2Map = 0x1559;
  static constexpr Tagged_t kLoadHandler3Map = 0x1581;
  static constexpr Tagged_t kStoreHandler0Map = 0x15a9;
  static constexpr Tagged_t kStoreHandler1Map = 0x15d1;
  static constexpr Tagged_t kStoreHandler2Map = 0x15f9;
  static constexpr Tagged_t kStoreHandler3Map = 0x1621;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x1649;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x1671;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x1699;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x16c1;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x16e9;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x1711;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x1739;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x1761;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x1789;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x17b1;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x17d9;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x1801;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x1829;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x1851;
  static constexpr Tagged_t kInternalClassMap = 0x1879;
  static constexpr Tagged_t kSmiPairMap = 0x18a1;
  static constexpr Tagged_t kSmiBoxMap = 0x18c9;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x18f1;
  static constexpr Tagged_t kExportedSubClassMap = 0x1919;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x1941;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x1969;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1991;
  static constexpr Tagged_t kSortStateMap = 0x19b9;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x19e1;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x1a09;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1a31;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1a59;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1a81;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1aa9;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1ad1;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1af9;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1b21;
  static constexpr Tagged_t kSimpleNameDictionaryMap = 0x1b49;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1b71;
  static constexpr Tagged_t kDoubleStringCacheMap = 0x1b99;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1bc1;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1be9;
  static constexpr Tagged_t kScriptContextTableMap = 0x1c11;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1c39;
  static constexpr Tagged_t kCoverageInfoMap = 0x1c61;
  static constexpr Tagged_t kRegExpMatchInfoMap = 0x1c89;
  static constexpr Tagged_t kRegExpDataMap = 0x1cb1;
  static constexpr Tagged_t kAtomRegExpDataMap = 0x1cd9;
  static constexpr Tagged_t kIrRegExpDataMap = 0x1d01;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1d29;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1d51;
  static constexpr Tagged_t kContextCellMap = 0x1d79;
  static constexpr Tagged_t kWeakCellMap = 0x1da1;
  static constexpr Tagged_t kInterpreterDataMap = 0x1dc9;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x1df1;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x1e19;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x1e41;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x1e69;
  static constexpr Tagged_t kSharedFunctionInfoWrapperMap = 0x1e91;
  static constexpr Tagged_t kDictionaryTemplateInfoMap = 0x1eb9;
  static constexpr Tagged_t kEmptyArrayList = 0x1ee1;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x1eed;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x1efd;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x1f09;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x1f1d;
  static constexpr Tagged_t kadoptText_string = 0x1f3d;
  static constexpr Tagged_t kapproximatelySign_string = 0x1f55;
  static constexpr Tagged_t kbaseName_string = 0x1f75;
  static constexpr Tagged_t kaccounting_string = 0x1f89;
  static constexpr Tagged_t kbreakType_string = 0x1fa1;
  static constexpr Tagged_t kcalendars_string = 0x1fb9;
  static constexpr Tagged_t kcardinal_string = 0x1fd1;
  static constexpr Tagged_t kcaseFirst_string = 0x1fe5;
  static constexpr Tagged_t kceil_string = 0x1ffd;
  static constexpr Tagged_t kcompare_string = 0x200d;
  static constexpr Tagged_t kcollation_string = 0x2021;
  static constexpr Tagged_t kcollations_string = 0x2039;
  static constexpr Tagged_t kcompact_string = 0x2051;
  static constexpr Tagged_t kcompactDisplay_string = 0x2065;
  static constexpr Tagged_t kcurrency_string = 0x2081;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x2095;
  static constexpr Tagged_t kcurrencySign_string = 0x20b1;
  static constexpr Tagged_t kdateStyle_string = 0x20c9;
  static constexpr Tagged_t kdateTimeField_string = 0x20e1;
  static constexpr Tagged_t kdayPeriod_string = 0x20fd;
  static constexpr Tagged_t kdaysDisplay_string = 0x2115;
  static constexpr Tagged_t kdecimal_string = 0x212d;
  static constexpr Tagged_t kdialect_string = 0x2141;
  static constexpr Tagged_t kdigital_string = 0x2155;
  static constexpr Tagged_t kendRange_string = 0x2169;
  static constexpr Tagged_t kengineering_string = 0x217d;
  static constexpr Tagged_t kexceptZero_string = 0x2195;
  static constexpr Tagged_t kexpand_string = 0x21ad;
  static constexpr Tagged_t kexponentInteger_string = 0x21c1;
  static constexpr Tagged_t kexponentMinusSign_string = 0x21dd;
  static constexpr Tagged_t kexponentSeparator_string = 0x21fd;
  static constexpr Tagged_t kfallback_string = 0x221d;
  static constexpr Tagged_t kfirst_string = 0x2231;
  static constexpr Tagged_t kfirstDay_string = 0x2245;
  static constexpr Tagged_t kfirstDayOfWeek_string = 0x2259;
  static constexpr Tagged_t kfloor_string = 0x2275;
  static constexpr Tagged_t kformat_string = 0x2289;
  static constexpr Tagged_t kformatMatcher_string = 0x229d;
  static constexpr Tagged_t kfraction_string = 0x22b9;
  static constexpr Tagged_t kfractionalDigits_string = 0x22cd;
  static constexpr Tagged_t kfractionalSecond_string = 0x22e9;
  static constexpr Tagged_t kfull_string = 0x2305;
  static constexpr Tagged_t kgranularity_string = 0x2315;
  static constexpr Tagged_t kgrapheme_string = 0x232d;
  static constexpr Tagged_t kgroup_string = 0x2341;
  static constexpr Tagged_t kh11_string = 0x2355;
  static constexpr Tagged_t kh12_string = 0x2365;
  static constexpr Tagged_t kh23_string = 0x2375;
  static constexpr Tagged_t kh24_string = 0x2385;
  static constexpr Tagged_t khalfCeil_string = 0x2395;
  static constexpr Tagged_t khalfEven_string = 0x23a9;
  static constexpr Tagged_t khalfExpand_string = 0x23bd;
  static constexpr Tagged_t khalfFloor_string = 0x23d5;
  static constexpr Tagged_t khalfTrunc_string = 0x23ed;
  static constexpr Tagged_t khour12_string = 0x2405;
  static constexpr Tagged_t khourCycle_string = 0x2419;
  static constexpr Tagged_t khourCycles_string = 0x2431;
  static constexpr Tagged_t khoursDisplay_string = 0x2449;
  static constexpr Tagged_t kideo_string = 0x2461;
  static constexpr Tagged_t kignorePunctuation_string = 0x2471;
  static constexpr Tagged_t kInvalid_Date_string = 0x2491;
  static constexpr Tagged_t kinteger_string = 0x24a9;
  static constexpr Tagged_t kisWordLike_string = 0x24bd;
  static constexpr Tagged_t kkana_string = 0x24d5;
  static constexpr Tagged_t klanguage_string = 0x24e5;
  static constexpr Tagged_t klanguageDisplay_string = 0x24f9;
  static constexpr Tagged_t klessPrecision_string = 0x2515;
  static constexpr Tagged_t kletter_string = 0x2531;
  static constexpr Tagged_t klist_string = 0x2545;
  static constexpr Tagged_t kliteral_string = 0x2555;
  static constexpr Tagged_t klocale_string = 0x2569;
  static constexpr Tagged_t klocaleMatcher_string = 0x257d;
  static constexpr Tagged_t kloose_string = 0x2599;
  static constexpr Tagged_t klower_string = 0x25ad;
  static constexpr Tagged_t kltr_string = 0x25c1;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x25d1;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x25f5;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x2619;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x2639;
  static constexpr Tagged_t kmin2_string = 0x2659;
  static constexpr Tagged_t kminimalDays_string = 0x2669;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x2681;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x26a5;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x26c5;
  static constexpr Tagged_t kminus_0 = 0x26e9;
  static constexpr Tagged_t kminusSign_string = 0x26f9;
  static constexpr Tagged_t kminutesDisplay_string = 0x2711;
  static constexpr Tagged_t kmonthsDisplay_string = 0x272d;
  static constexpr Tagged_t kmorePrecision_string = 0x2749;
  static constexpr Tagged_t knan_string = 0x2765;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x2775;
  static constexpr Tagged_t knarrowSymbol_string = 0x2795;
  static constexpr Tagged_t knegative_string = 0x27ad;
  static constexpr Tagged_t knever_string = 0x27c1;
  static constexpr Tagged_t knone_string = 0x27d5;
  static constexpr Tagged_t knotation_string = 0x27e5;
  static constexpr Tagged_t knormal_string = 0x27f9;
  static constexpr Tagged_t knumberingSystem_string = 0x280d;
  static constexpr Tagged_t knumberingSystems_string = 0x2829;
  static constexpr Tagged_t knumeric_string = 0x2845;
  static constexpr Tagged_t kordinal_string = 0x2859;
  static constexpr Tagged_t kpercentSign_string = 0x286d;
  static constexpr Tagged_t kplusSign_string = 0x2885;
  static constexpr Tagged_t kquarter_string = 0x2899;
  static constexpr Tagged_t kregion_string = 0x28ad;
  static constexpr Tagged_t krelatedYear_string = 0x28c1;
  static constexpr Tagged_t kroundingPriority_string = 0x28d9;
  static constexpr Tagged_t krtl_string = 0x28f5;
  static constexpr Tagged_t kscientific_string = 0x2905;
  static constexpr Tagged_t ksecondsDisplay_string = 0x291d;
  static constexpr Tagged_t ksegment_string = 0x2939;
  static constexpr Tagged_t kSegmentIterator_string = 0x294d;
  static constexpr Tagged_t kSegments_string = 0x2969;
  static constexpr Tagged_t ksensitivity_string = 0x297d;
  static constexpr Tagged_t ksep_string = 0x2995;
  static constexpr Tagged_t kshared_string = 0x29a5;
  static constexpr Tagged_t ksignDisplay_string = 0x29b9;
  static constexpr Tagged_t kstandard_string = 0x29d1;
  static constexpr Tagged_t kstartRange_string = 0x29e5;
  static constexpr Tagged_t kstrict_string = 0x29fd;
  static constexpr Tagged_t kstripIfInteger_string = 0x2a11;
  static constexpr Tagged_t kstyle_string = 0x2a2d;
  static constexpr Tagged_t kterm_string = 0x2a41;
  static constexpr Tagged_t ktextInfo_string = 0x2a51;
  static constexpr Tagged_t ktimeStyle_string = 0x2a65;
  static constexpr Tagged_t ktimeZones_string = 0x2a7d;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x2a95;
  static constexpr Tagged_t ktrunc_string = 0x2ab5;
  static constexpr Tagged_t ktwo_digit_string = 0x2ac9;
  static constexpr Tagged_t ktype_string = 0x2add;
  static constexpr Tagged_t kunknown_string = 0x2aed;
  static constexpr Tagged_t kupper_string = 0x2b01;
  static constexpr Tagged_t kusage_string = 0x2b15;
  static constexpr Tagged_t kuseGrouping_string = 0x2b29;
  static constexpr Tagged_t kunitDisplay_string = 0x2b41;
  static constexpr Tagged_t kweekday_string = 0x2b59;
  static constexpr Tagged_t kweekend_string = 0x2b6d;
  static constexpr Tagged_t kweeksDisplay_string = 0x2b81;
  static constexpr Tagged_t kweekInfo_string = 0x2b99;
  static constexpr Tagged_t kyearName_string = 0x2bad;
  static constexpr Tagged_t kyearsDisplay_string = 0x2bc1;
  static constexpr Tagged_t kascii_nul_string = 0x2bd9;
  static constexpr Tagged_t kascii_soh_string = 0x2be9;
  static constexpr Tagged_t kascii_stx_string = 0x2bf9;
  static constexpr Tagged_t kascii_etx_string = 0x2c09;
  static constexpr Tagged_t kascii_eot_string = 0x2c19;
  static constexpr Tagged_t kascii_enq_string = 0x2c29;
  static constexpr Tagged_t kascii_ack_string = 0x2c39;
  static constexpr Tagged_t kascii_bel_string = 0x2c49;
  static constexpr Tagged_t kascii_bs_string = 0x2c59;
  static constexpr Tagged_t kascii_ht_string = 0x2c69;
  static constexpr Tagged_t kascii_lf_string = 0x2c79;
  static constexpr Tagged_t kascii_vt_string = 0x2c89;
  static constexpr Tagged_t kascii_ff_string = 0x2c99;
  static constexpr Tagged_t kascii_cr_string = 0x2ca9;
  static constexpr Tagged_t kascii_so_string = 0x2cb9;
  static constexpr Tagged_t kascii_si_string = 0x2cc9;
  static constexpr Tagged_t kascii_dle_string = 0x2cd9;
  static constexpr Tagged_t kascii_dc1_string = 0x2ce9;
  static constexpr Tagged_t kascii_dc2_string = 0x2cf9;
  static constexpr Tagged_t kascii_dc3_string = 0x2d09;
  static constexpr Tagged_t kascii_dc4_string = 0x2d19;
  static constexpr Tagged_t kascii_nak_string = 0x2d29;
  static constexpr Tagged_t kascii_syn_string = 0x2d39;
  static constexpr Tagged_t kascii_etb_string = 0x2d49;
  static constexpr Tagged_t kascii_can_string = 0x2d59;
  static constexpr Tagged_t kascii_em_string = 0x2d69;
  static constexpr Tagged_t kascii_sub_string = 0x2d79;
  static constexpr Tagged_t kascii_esc_string = 0x2d89;
  static constexpr Tagged_t kascii_fs_string = 0x2d99;
  static constexpr Tagged_t kascii_gs_string = 0x2da9;
  static constexpr Tagged_t kascii_rs_string = 0x2db9;
  static constexpr Tagged_t kascii_us_string = 0x2dc9;
  static constexpr Tagged_t kspace_string = 0x2dd9;
  static constexpr Tagged_t kexclamation_mark_string = 0x2de9;
  static constexpr Tagged_t kdouble_quotes_string = 0x2df9;
  static constexpr Tagged_t khash_string = 0x2e09;
  static constexpr Tagged_t kdollar_string = 0x2e19;
  static constexpr Tagged_t kpercent_sign_string = 0x2e29;
  static constexpr Tagged_t kampersand_string = 0x2e39;
  static constexpr Tagged_t ksingle_quote_string = 0x2e49;
  static constexpr Tagged_t kopen_parenthesis_string = 0x2e59;
  static constexpr Tagged_t kclose_parenthesis_string = 0x2e69;
  static constexpr Tagged_t kasterisk_string = 0x2e79;
  static constexpr Tagged_t kplus_string = 0x2e89;
  static constexpr Tagged_t kcomma_string = 0x2e99;
  static constexpr Tagged_t kminus_string = 0x2ea9;
  static constexpr Tagged_t kdot_string = 0x2eb9;
  static constexpr Tagged_t kslash_string = 0x2ec9;
  static constexpr Tagged_t kzero_string = 0x2ed9;
  static constexpr Tagged_t kone_string = 0x2ee9;
  static constexpr Tagged_t ktwo_string = 0x2ef9;
  static constexpr Tagged_t kthree_string = 0x2f09;
  static constexpr Tagged_t kfour_string = 0x2f19;
  static constexpr Tagged_t kfive_string = 0x2f29;
  static constexpr Tagged_t ksix_string = 0x2f39;
  static constexpr Tagged_t kseven_string = 0x2f49;
  static constexpr Tagged_t keight_string = 0x2f59;
  static constexpr Tagged_t knine_string = 0x2f69;
  static constexpr Tagged_t kcolon_string = 0x2f79;
  static constexpr Tagged_t ksemicolon_string = 0x2f89;
  static constexpr Tagged_t kless_than_string = 0x2f99;
  static constexpr Tagged_t kequals_string = 0x2fa9;
  static constexpr Tagged_t kgreater_than_string = 0x2fb9;
  static constexpr Tagged_t kquestion_mark_string = 0x2fc9;
  static constexpr Tagged_t kat_sign_string = 0x2fd9;
  static constexpr Tagged_t kA_string = 0x2fe9;
  static constexpr Tagged_t kB_string = 0x2ff9;
  static constexpr Tagged_t kC_string = 0x3009;
  static constexpr Tagged_t kD_string = 0x3019;
  static constexpr Tagged_t kE_string = 0x3029;
  static constexpr Tagged_t kF_string = 0x3039;
  static constexpr Tagged_t kG_string = 0x3049;
  static constexpr Tagged_t kH_string = 0x3059;
  static constexpr Tagged_t kI_string = 0x3069;
  static constexpr Tagged_t kJ_string = 0x3079;
  static constexpr Tagged_t kK_string = 0x3089;
  static constexpr Tagged_t kL_string = 0x3099;
  static constexpr Tagged_t kM_string = 0x30a9;
  static constexpr Tagged_t kN_string = 0x30b9;
  static constexpr Tagged_t kO_string = 0x30c9;
  static constexpr Tagged_t kP_string = 0x30d9;
  static constexpr Tagged_t kQ_string = 0x30e9;
  static constexpr Tagged_t kR_string = 0x30f9;
  static constexpr Tagged_t kS_string = 0x3109;
  static constexpr Tagged_t kT_string = 0x3119;
  static constexpr Tagged_t kU_string = 0x3129;
  static constexpr Tagged_t kV_string = 0x3139;
  static constexpr Tagged_t kW_string = 0x3149;
  static constexpr Tagged_t kX_string = 0x3159;
  static constexpr Tagged_t kY_string = 0x3169;
  static constexpr Tagged_t kZ_string = 0x3179;
  static constexpr Tagged_t kopen_bracket_string = 0x3189;
  static constexpr Tagged_t kbackslash_string = 0x3199;
  static constexpr Tagged_t kclose_bracket_string = 0x31a9;
  static constexpr Tagged_t kcaret_string = 0x31b9;
  static constexpr Tagged_t kunderscore_string = 0x31c9;
  static constexpr Tagged_t kbacktick_string = 0x31d9;
  static constexpr Tagged_t ka_string = 0x31e9;
  static constexpr Tagged_t kb_string = 0x31f9;
  static constexpr Tagged_t kc_string = 0x3209;
  static constexpr Tagged_t kd_string = 0x3219;
  static constexpr Tagged_t ke_string = 0x3229;
  static constexpr Tagged_t kf_string = 0x3239;
  static constexpr Tagged_t kg_string = 0x3249;
  static constexpr Tagged_t kh_string = 0x3259;
  static constexpr Tagged_t ki_string = 0x3269;
  static constexpr Tagged_t kj_string = 0x3279;
  static constexpr Tagged_t kk_string = 0x3289;
  static constexpr Tagged_t kl_string = 0x3299;
  static constexpr Tagged_t km_string = 0x32a9;
  static constexpr Tagged_t kn_string = 0x32b9;
  static constexpr Tagged_t ko_string = 0x32c9;
  static constexpr Tagged_t kp_string = 0x32d9;
  static constexpr Tagged_t kq_string = 0x32e9;
  static constexpr Tagged_t kr_string = 0x32f9;
  static constexpr Tagged_t ks_string = 0x3309;
  static constexpr Tagged_t kt_string = 0x3319;
  static constexpr Tagged_t ku_string = 0x3329;
  static constexpr Tagged_t kv_string = 0x3339;
  static constexpr Tagged_t kw_string = 0x3349;
  static constexpr Tagged_t kx_string = 0x3359;
  static constexpr Tagged_t ky_string = 0x3369;
  static constexpr Tagged_t kz_string = 0x3379;
  static constexpr Tagged_t kopen_brace_string = 0x3389;
  static constexpr Tagged_t kpipe_string = 0x3399;
  static constexpr Tagged_t kclose_brace_string = 0x33a9;
  static constexpr Tagged_t ktilde_string = 0x33b9;
  static constexpr Tagged_t kascii_del_string = 0x33c9;
  static constexpr Tagged_t klatin1_80_string = 0x33d9;
  static constexpr Tagged_t klatin1_81_string = 0x33e9;
  static constexpr Tagged_t klatin1_82_string = 0x33f9;
  static constexpr Tagged_t klatin1_83_string = 0x3409;
  static constexpr Tagged_t klatin1_84_string = 0x3419;
  static constexpr Tagged_t klatin1_85_string = 0x3429;
  static constexpr Tagged_t klatin1_86_string = 0x3439;
  static constexpr Tagged_t klatin1_87_string = 0x3449;
  static constexpr Tagged_t klatin1_88_string = 0x3459;
  static constexpr Tagged_t klatin1_89_string = 0x3469;
  static constexpr Tagged_t klatin1_8a_string = 0x3479;
  static constexpr Tagged_t klatin1_8b_string = 0x3489;
  static constexpr Tagged_t klatin1_8c_string = 0x3499;
  static constexpr Tagged_t klatin1_8d_string = 0x34a9;
  static constexpr Tagged_t klatin1_8e_string = 0x34b9;
  static constexpr Tagged_t klatin1_8f_string = 0x34c9;
  static constexpr Tagged_t klatin1_90_string = 0x34d9;
  static constexpr Tagged_t klatin1_91_string = 0x34e9;
  static constexpr Tagged_t klatin1_92_string = 0x34f9;
  static constexpr Tagged_t klatin1_93_string = 0x3509;
  static constexpr Tagged_t klatin1_94_string = 0x3519;
  static constexpr Tagged_t klatin1_95_string = 0x3529;
  static constexpr Tagged_t klatin1_96_string = 0x3539;
  static constexpr Tagged_t klatin1_97_string = 0x3549;
  static constexpr Tagged_t klatin1_98_string = 0x3559;
  static constexpr Tagged_t klatin1_99_string = 0x3569;
  static constexpr Tagged_t klatin1_9a_string = 0x3579;
  static constexpr Tagged_t klatin1_9b_string = 0x3589;
  static constexpr Tagged_t klatin1_9c_string = 0x3599;
  static constexpr Tagged_t klatin1_9d_string = 0x35a9;
  static constexpr Tagged_t klatin1_9e_string = 0x35b9;
  static constexpr Tagged_t klatin1_9f_string = 0x35c9;
  static constexpr Tagged_t klatin1_a0_string = 0x35d9;
  static constexpr Tagged_t klatin1_a1_string = 0x35e9;
  static constexpr Tagged_t klatin1_a2_string = 0x35f9;
  static constexpr Tagged_t klatin1_a3_string = 0x3609;
  static constexpr Tagged_t klatin1_a4_string = 0x3619;
  static constexpr Tagged_t klatin1_a5_string = 0x3629;
  static constexpr Tagged_t klatin1_a6_string = 0x3639;
  static constexpr Tagged_t klatin1_a7_string = 0x3649;
  static constexpr Tagged_t klatin1_a8_string = 0x3659;
  static constexpr Tagged_t klatin1_a9_string = 0x3669;
  static constexpr Tagged_t klatin1_aa_string = 0x3679;
  static constexpr Tagged_t klatin1_ab_string = 0x3689;
  static constexpr Tagged_t klatin1_ac_string = 0x3699;
  static constexpr Tagged_t klatin1_ad_string = 0x36a9;
  static constexpr Tagged_t klatin1_ae_string = 0x36b9;
  static constexpr Tagged_t klatin1_af_string = 0x36c9;
  static constexpr Tagged_t klatin1_b0_string = 0x36d9;
  static constexpr Tagged_t klatin1_b1_string = 0x36e9;
  static constexpr Tagged_t klatin1_b2_string = 0x36f9;
  static constexpr Tagged_t klatin1_b3_string = 0x3709;
  static constexpr Tagged_t klatin1_b4_string = 0x3719;
  static constexpr Tagged_t klatin1_b5_string = 0x3729;
  static constexpr Tagged_t klatin1_b6_string = 0x3739;
  static constexpr Tagged_t klatin1_b7_string = 0x3749;
  static constexpr Tagged_t klatin1_b8_string = 0x3759;
  static constexpr Tagged_t klatin1_b9_string = 0x3769;
  static constexpr Tagged_t klatin1_ba_string = 0x3779;
  static constexpr Tagged_t klatin1_bb_string = 0x3789;
  static constexpr Tagged_t klatin1_bc_string = 0x3799;
  static constexpr Tagged_t klatin1_bd_string = 0x37a9;
  static constexpr Tagged_t klatin1_be_string = 0x37b9;
  static constexpr Tagged_t klatin1_bf_string = 0x37c9;
  static constexpr Tagged_t klatin1_c0_string = 0x37d9;
  static constexpr Tagged_t klatin1_c1_string = 0x37e9;
  static constexpr Tagged_t klatin1_c2_string = 0x37f9;
  static constexpr Tagged_t klatin1_c3_string = 0x3809;
  static constexpr Tagged_t klatin1_c4_string = 0x3819;
  static constexpr Tagged_t klatin1_c5_string = 0x3829;
  static constexpr Tagged_t klatin1_c6_string = 0x3839;
  static constexpr Tagged_t klatin1_c7_string = 0x3849;
  static constexpr Tagged_t klatin1_c8_string = 0x3859;
  static constexpr Tagged_t klatin1_c9_string = 0x3869;
  static constexpr Tagged_t klatin1_ca_string = 0x3879;
  static constexpr Tagged_t klatin1_cb_string = 0x3889;
  static constexpr Tagged_t klatin1_cc_string = 0x3899;
  static constexpr Tagged_t klatin1_cd_string = 0x38a9;
  static constexpr Tagged_t klatin1_ce_string = 0x38b9;
  static constexpr Tagged_t klatin1_cf_string = 0x38c9;
  static constexpr Tagged_t klatin1_d0_string = 0x38d9;
  static constexpr Tagged_t klatin1_d1_string = 0x38e9;
  static constexpr Tagged_t klatin1_d2_string = 0x38f9;
  static constexpr Tagged_t klatin1_d3_string = 0x3909;
  static constexpr Tagged_t klatin1_d4_string = 0x3919;
  static constexpr Tagged_t klatin1_d5_string = 0x3929;
  static constexpr Tagged_t klatin1_d6_string = 0x3939;
  static constexpr Tagged_t klatin1_d7_string = 0x3949;
  static constexpr Tagged_t klatin1_d8_string = 0x3959;
  static constexpr Tagged_t klatin1_d9_string = 0x3969;
  static constexpr Tagged_t klatin1_da_string = 0x3979;
  static constexpr Tagged_t klatin1_db_string = 0x3989;
  static constexpr Tagged_t klatin1_dc_string = 0x3999;
  static constexpr Tagged_t klatin1_dd_string = 0x39a9;
  static constexpr Tagged_t klatin1_de_string = 0x39b9;
  static constexpr Tagged_t klatin1_df_string = 0x39c9;
  static constexpr Tagged_t klatin1_e0_string = 0x39d9;
  static constexpr Tagged_t klatin1_e1_string = 0x39e9;
  static constexpr Tagged_t klatin1_e2_string = 0x39f9;
  static constexpr Tagged_t klatin1_e3_string = 0x3a09;
  static constexpr Tagged_t klatin1_e4_string = 0x3a19;
  static constexpr Tagged_t klatin1_e5_string = 0x3a29;
  static constexpr Tagged_t klatin1_e6_string = 0x3a39;
  static constexpr Tagged_t klatin1_e7_string = 0x3a49;
  static constexpr Tagged_t klatin1_e8_string = 0x3a59;
  static constexpr Tagged_t klatin1_e9_string = 0x3a69;
  static constexpr Tagged_t klatin1_ea_string = 0x3a79;
  static constexpr Tagged_t klatin1_eb_string = 0x3a89;
  static constexpr Tagged_t klatin1_ec_string = 0x3a99;
  static constexpr Tagged_t klatin1_ed_string = 0x3aa9;
  static constexpr Tagged_t klatin1_ee_string = 0x3ab9;
  static constexpr Tagged_t klatin1_ef_string = 0x3ac9;
  static constexpr Tagged_t klatin1_f0_string = 0x3ad9;
  static constexpr Tagged_t klatin1_f1_string = 0x3ae9;
  static constexpr Tagged_t klatin1_f2_string = 0x3af9;
  static constexpr Tagged_t klatin1_f3_string = 0x3b09;
  static constexpr Tagged_t klatin1_f4_string = 0x3b19;
  static constexpr Tagged_t klatin1_f5_string = 0x3b29;
  static constexpr Tagged_t klatin1_f6_string = 0x3b39;
  static constexpr Tagged_t klatin1_f7_string = 0x3b49;
  static constexpr Tagged_t klatin1_f8_string = 0x3b59;
  static constexpr Tagged_t klatin1_f9_string = 0x3b69;
  static constexpr Tagged_t klatin1_fa_string = 0x3b79;
  static constexpr Tagged_t klatin1_fb_string = 0x3b89;
  static constexpr Tagged_t klatin1_fc_string = 0x3b99;
  static constexpr Tagged_t klatin1_fd_string = 0x3ba9;
  static constexpr Tagged_t klatin1_fe_string = 0x3bb9;
  static constexpr Tagged_t klatin1_ff_string = 0x3bc9;
  static constexpr Tagged_t kadd_string = 0x3bd9;
  static constexpr Tagged_t kAggregateError_string = 0x3be9;
  static constexpr Tagged_t kalphabet_string = 0x3c05;
  static constexpr Tagged_t kalways_string = 0x3c19;
  static constexpr Tagged_t kanonymous_string = 0x3c2d;
  static constexpr Tagged_t kapply_string = 0x3c45;
  static constexpr Tagged_t kArguments_string = 0x3c59;
  static constexpr Tagged_t karguments_string = 0x3c71;
  static constexpr Tagged_t karguments_to_string = 0x3c89;
  static constexpr Tagged_t kArray_string = 0x3ca9;
  static constexpr Tagged_t karray_to_string = 0x3cbd;
  static constexpr Tagged_t kArrayBuffer_string = 0x3cd9;
  static constexpr Tagged_t kArrayIterator_string = 0x3cf1;
  static constexpr Tagged_t kas_string = 0x3d0d;
  static constexpr Tagged_t kassert_string = 0x3d1d;
  static constexpr Tagged_t kasync_string = 0x3d31;
  static constexpr Tagged_t kAtomicsCondition_string = 0x3d45;
  static constexpr Tagged_t kAtomicsMutex_string = 0x3d65;
  static constexpr Tagged_t kauto_string = 0x3d81;
  static constexpr Tagged_t kBigInt_string = 0x3d91;
  static constexpr Tagged_t kbigint_string = 0x3da5;
  static constexpr Tagged_t kBigInt64Array_string = 0x3db9;
  static constexpr Tagged_t kBigUint64Array_string = 0x3dd5;
  static constexpr Tagged_t kbind_string = 0x3df1;
  static constexpr Tagged_t kblank_string = 0x3e01;
  static constexpr Tagged_t kBoolean_string = 0x3e15;
  static constexpr Tagged_t kboolean_string = 0x3e29;
  static constexpr Tagged_t kboolean_to_string = 0x3e3d;
  static constexpr Tagged_t kbound__string = 0x3e59;
  static constexpr Tagged_t kbuffer_string = 0x3e6d;
  static constexpr Tagged_t kbyte_length_string = 0x3e81;
  static constexpr Tagged_t kbyte_offset_string = 0x3e99;
  static constexpr Tagged_t kCompileError_string = 0x3eb1;
  static constexpr Tagged_t kcalendar_string = 0x3ec9;
  static constexpr Tagged_t kcalendarId_string = 0x3edd;
  static constexpr Tagged_t kcalendarName_string = 0x3ef5;
  static constexpr Tagged_t kcallee_string = 0x3f0d;
  static constexpr Tagged_t kcaller_string = 0x3f21;
  static constexpr Tagged_t kcause_string = 0x3f35;
  static constexpr Tagged_t kcharacter_string = 0x3f49;
  static constexpr Tagged_t kcode_string = 0x3f61;
  static constexpr Tagged_t kcolumn_string = 0x3f71;
  static constexpr Tagged_t kcomputed_string = 0x3f85;
  static constexpr Tagged_t kconjunction_string = 0x3f9d;
  static constexpr Tagged_t kconsole_string = 0x3fb5;
  static constexpr Tagged_t kconstrain_string = 0x3fc9;
  static constexpr Tagged_t kconstruct_string = 0x3fe1;
  static constexpr Tagged_t kcurrent_string = 0x3ff9;
  static constexpr Tagged_t kDate_string = 0x400d;
  static constexpr Tagged_t kdate_to_string = 0x401d;
  static constexpr Tagged_t kdateAdd_string = 0x4039;
  static constexpr Tagged_t kdateFromFields_string = 0x404d;
  static constexpr Tagged_t kdateUntil_string = 0x4069;
  static constexpr Tagged_t kday_string = 0x4081;
  static constexpr Tagged_t kdayOfWeek_string = 0x4091;
  static constexpr Tagged_t kdayOfYear_string = 0x40a9;
  static constexpr Tagged_t kdays_string = 0x40c1;
  static constexpr Tagged_t kdaysInMonth_string = 0x40d1;
  static constexpr Tagged_t kdaysInWeek_string = 0x40e9;
  static constexpr Tagged_t kdaysInYear_string = 0x4101;
  static constexpr Tagged_t kdefault_string = 0x4119;
  static constexpr Tagged_t kdefineProperty_string = 0x412d;
  static constexpr Tagged_t kdeleteProperty_string = 0x4149;
  static constexpr Tagged_t kdetached_string = 0x4165;
  static constexpr Tagged_t kdirection_string = 0x4179;
  static constexpr Tagged_t kdisambiguation_string = 0x4191;
  static constexpr Tagged_t kdisjunction_string = 0x41ad;
  static constexpr Tagged_t kdisposed_string = 0x41c5;
  static constexpr Tagged_t kdone_string = 0x41d9;
  static constexpr Tagged_t kdot_brand_string = 0x41e9;
  static constexpr Tagged_t kdot_catch_string = 0x41fd;
  static constexpr Tagged_t kdot_default_string = 0x4211;
  static constexpr Tagged_t kdot_for_string = 0x4225;
  static constexpr Tagged_t kdot_generator_object_string = 0x4235;
  static constexpr Tagged_t kdot_home_object_string = 0x4255;
  static constexpr Tagged_t kdot_new_target_string = 0x426d;
  static constexpr Tagged_t knew_target_string = 0x426d;
  static constexpr Tagged_t kdot_result_string = 0x4285;
  static constexpr Tagged_t kdot_repl_result_string = 0x4299;
  static constexpr Tagged_t kdot_static_home_object_string = 0x42b1;
  static constexpr Tagged_t kdot_switch_tag_string = 0x42d1;
  static constexpr Tagged_t kdotAll_string = 0x42e9;
  static constexpr Tagged_t kError_string = 0x42fd;
  static constexpr Tagged_t kEvalError_string = 0x4311;
  static constexpr Tagged_t kelement_string = 0x4329;
  static constexpr Tagged_t kepochMilliseconds_string = 0x433d;
  static constexpr Tagged_t kepochNanoseconds_string = 0x435d;
  static constexpr Tagged_t kera_string = 0x4379;
  static constexpr Tagged_t keraYear_string = 0x4389;
  static constexpr Tagged_t kerror_string = 0x439d;
  static constexpr Tagged_t kerrors_string = 0x43b1;
  static constexpr Tagged_t kerror_to_string = 0x43c5;
  static constexpr Tagged_t keval_string = 0x43e1;
  static constexpr Tagged_t kexception_string = 0x43f1;
  static constexpr Tagged_t kexec_string = 0x4409;
  static constexpr Tagged_t kfalse_string = 0x4419;
  static constexpr Tagged_t kfields_string = 0x442d;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4441;
  static constexpr Tagged_t kflags_string = 0x4461;
  static constexpr Tagged_t kFloat16Array_string = 0x4475;
  static constexpr Tagged_t kFloat32Array_string = 0x448d;
  static constexpr Tagged_t kFloat64Array_string = 0x44a5;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x44bd;
  static constexpr Tagged_t kfrom_string = 0x44e1;
  static constexpr Tagged_t kFunction_string = 0x44f1;
  static constexpr Tagged_t kfunction_native_code_string = 0x4505;
  static constexpr Tagged_t kfunction_string = 0x4531;
  static constexpr Tagged_t kfunction_to_string = 0x4545;
  static constexpr Tagged_t kGenerator_string = 0x4565;
  static constexpr Tagged_t kget_space_string = 0x457d;
  static constexpr Tagged_t kget_string = 0x458d;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x459d;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x45c1;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x45e5;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4609;
  static constexpr Tagged_t kgetTimeZoneTransition_string = 0x4625;
  static constexpr Tagged_t kglobal_string = 0x4649;
  static constexpr Tagged_t kglobalThis_string = 0x465d;
  static constexpr Tagged_t kgroups_string = 0x4675;
  static constexpr Tagged_t kgrowable_string = 0x4689;
  static constexpr Tagged_t khas_string = 0x469d;
  static constexpr Tagged_t khasIndices_string = 0x46ad;
  static constexpr Tagged_t khour_string = 0x46c5;
  static constexpr Tagged_t khours_string = 0x46d5;
  static constexpr Tagged_t khoursInDay_string = 0x46e9;
  static constexpr Tagged_t kignoreCase_string = 0x4701;
  static constexpr Tagged_t kid_string = 0x4719;
  static constexpr Tagged_t killegal_access_string = 0x4729;
  static constexpr Tagged_t killegal_argument_string = 0x4745;
  static constexpr Tagged_t kinLeapYear_string = 0x4761;
  static constexpr Tagged_t kindex_string = 0x4779;
  static constexpr Tagged_t kindices_string = 0x478d;
  static constexpr Tagged_t kInfinity_string = 0x47a1;
  static constexpr Tagged_t kinfinity_string = 0x47b5;
  static constexpr Tagged_t kinput_string = 0x47c9;
  static constexpr Tagged_t kinstance_members_initializer_string = 0x47dd;
  static constexpr Tagged_t kInt16Array_string = 0x4809;
  static constexpr Tagged_t kInt32Array_string = 0x4821;
  static constexpr Tagged_t kInt8Array_string = 0x4839;
  static constexpr Tagged_t kisExtensible_string = 0x4851;
  static constexpr Tagged_t kiso8601_string = 0x4869;
  static constexpr Tagged_t kisoDay_string = 0x487d;
  static constexpr Tagged_t kisoHour_string = 0x4891;
  static constexpr Tagged_t kisoMicrosecond_string = 0x48a5;
  static constexpr Tagged_t kisoMillisecond_string = 0x48c1;
  static constexpr Tagged_t kisoMinute_string = 0x48dd;
  static constexpr Tagged_t kisoMonth_string = 0x48f5;
  static constexpr Tagged_t kisoNanosecond_string = 0x4909;
  static constexpr Tagged_t kisoSecond_string = 0x4925;
  static constexpr Tagged_t kisoYear_string = 0x493d;
  static constexpr Tagged_t kIterator_string = 0x4951;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4965;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4981;
  static constexpr Tagged_t kkeys_string = 0x499d;
  static constexpr Tagged_t klargestUnit_string = 0x49ad;
  static constexpr Tagged_t klast_chunk_handling_string = 0x49c5;
  static constexpr Tagged_t klastIndex_string = 0x49e5;
  static constexpr Tagged_t klet_string = 0x49fd;
  static constexpr Tagged_t kline_string = 0x4a0d;
  static constexpr Tagged_t klinear_string = 0x4a1d;
  static constexpr Tagged_t kLinkError_string = 0x4a31;
  static constexpr Tagged_t klong_string = 0x4a49;
  static constexpr Tagged_t kMap_string = 0x4a59;
  static constexpr Tagged_t kMapIterator_string = 0x4a69;
  static constexpr Tagged_t kmax_byte_length_string = 0x4a81;
  static constexpr Tagged_t kmedium_string = 0x4a9d;
  static constexpr Tagged_t kmergeFields_string = 0x4ab1;
  static constexpr Tagged_t kmessage_string = 0x4ac9;
  static constexpr Tagged_t kmeta_string = 0x4add;
  static constexpr Tagged_t kminus_Infinity_string = 0x4aed;
  static constexpr Tagged_t kmicrosecond_string = 0x4b05;
  static constexpr Tagged_t kmicroseconds_string = 0x4b1d;
  static constexpr Tagged_t kmillisecond_string = 0x4b35;
  static constexpr Tagged_t kmilliseconds_string = 0x4b4d;
  static constexpr Tagged_t kminute_string = 0x4b65;
  static constexpr Tagged_t kminutes_string = 0x4b79;
  static constexpr Tagged_t kModule_string = 0x4b8d;
  static constexpr Tagged_t kmonth_string = 0x4ba1;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x4bb5;
  static constexpr Tagged_t kmonths_string = 0x4bd5;
  static constexpr Tagged_t kmonthsInYear_string = 0x4be9;
  static constexpr Tagged_t kmonthCode_string = 0x4c01;
  static constexpr Tagged_t kmultiline_string = 0x4c19;
  static constexpr Tagged_t kNaN_string = 0x4c31;
  static constexpr Tagged_t knanosecond_string = 0x4c41;
  static constexpr Tagged_t knanoseconds_string = 0x4c59;
  static constexpr Tagged_t knarrow_string = 0x4c71;
  static constexpr Tagged_t knative_string = 0x4c85;
  static constexpr Tagged_t kNFC_string = 0x4c99;
  static constexpr Tagged_t kNFD_string = 0x4ca9;
  static constexpr Tagged_t kNFKC_string = 0x4cb9;
  static constexpr Tagged_t kNFKD_string = 0x4cc9;
  static constexpr Tagged_t knot_equal_string = 0x4cd9;
  static constexpr Tagged_t knull_string = 0x4cf1;
  static constexpr Tagged_t knull_to_string = 0x4d01;
  static constexpr Tagged_t kNumber_string = 0x4d1d;
  static constexpr Tagged_t knumber_string = 0x4d31;
  static constexpr Tagged_t knumber_to_string = 0x4d45;
  static constexpr Tagged_t kObject_string = 0x4d61;
  static constexpr Tagged_t kobject_string = 0x4d75;
  static constexpr Tagged_t kobject_to_string = 0x4d89;
  static constexpr Tagged_t kObject_prototype_string = 0x4da5;
  static constexpr Tagged_t koffset_string = 0x4dc1;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x4dd5;
  static constexpr Tagged_t kok_string = 0x4df5;
  static constexpr Tagged_t kother_string = 0x4e05;
  static constexpr Tagged_t koverflow_string = 0x4e19;
  static constexpr Tagged_t kownKeys_string = 0x4e2d;
  static constexpr Tagged_t kpercent_string = 0x4e41;
  static constexpr Tagged_t kplainDate_string = 0x4e55;
  static constexpr Tagged_t kplainTime_string = 0x4e6d;
  static constexpr Tagged_t kposition_string = 0x4e85;
  static constexpr Tagged_t kpreventExtensions_string = 0x4e99;
  static constexpr Tagged_t kprivate_constructor_string = 0x4eb9;
  static constexpr Tagged_t kPromise_string = 0x4ed1;
  static constexpr Tagged_t kpromise_string = 0x4ee5;
  static constexpr Tagged_t kproto_string = 0x4ef9;
  static constexpr Tagged_t kproxy_string = 0x4f11;
  static constexpr Tagged_t kProxy_string = 0x4f25;
  static constexpr Tagged_t kquery_colon_string = 0x4f39;
  static constexpr Tagged_t kRangeError_string = 0x4f49;
  static constexpr Tagged_t kraw_json_string = 0x4f61;
  static constexpr Tagged_t kraw_string = 0x4f75;
  static constexpr Tagged_t kread_string = 0x4f85;
  static constexpr Tagged_t kReferenceError_string = 0x4f95;
  static constexpr Tagged_t kReflectGet_string = 0x4fb1;
  static constexpr Tagged_t kReflectHas_string = 0x4fc9;
  static constexpr Tagged_t kRegExp_string = 0x4fe1;
  static constexpr Tagged_t kregexp_to_string = 0x4ff5;
  static constexpr Tagged_t kreject_string = 0x5011;
  static constexpr Tagged_t krelativeTo_string = 0x5025;
  static constexpr Tagged_t kresizable_string = 0x503d;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x5055;
  static constexpr Tagged_t kreturn_string = 0x5075;
  static constexpr Tagged_t krevoke_string = 0x5089;
  static constexpr Tagged_t kroundingIncrement_string = 0x509d;
  static constexpr Tagged_t kroundingMode_string = 0x50bd;
  static constexpr Tagged_t kRuntimeError_string = 0x50d5;
  static constexpr Tagged_t kWebAssemblyException_string = 0x50ed;
  static constexpr Tagged_t kWebAssemblyModule_string = 0x5111;
  static constexpr Tagged_t kScript_string = 0x5131;
  static constexpr Tagged_t kscript_string = 0x5145;
  static constexpr Tagged_t ksecond_string = 0x5159;
  static constexpr Tagged_t kseconds_string = 0x516d;
  static constexpr Tagged_t kshort_string = 0x5181;
  static constexpr Tagged_t kSet_string = 0x5195;
  static constexpr Tagged_t ksentence_string = 0x51a5;
  static constexpr Tagged_t kset_space_string = 0x51b9;
  static constexpr Tagged_t kset_string = 0x51c9;
  static constexpr Tagged_t kSetIterator_string = 0x51d9;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x51f1;
  static constexpr Tagged_t kShadowRealm_string = 0x520d;
  static constexpr Tagged_t kSharedArray_string = 0x5225;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x523d;
  static constexpr Tagged_t kSharedStruct_string = 0x525d;
  static constexpr Tagged_t ksign_string = 0x5275;
  static constexpr Tagged_t ksize_string = 0x5285;
  static constexpr Tagged_t ksmallestUnit_string = 0x5295;
  static constexpr Tagged_t ksource_string = 0x52ad;
  static constexpr Tagged_t ksourceText_string = 0x52c1;
  static constexpr Tagged_t kstack_string = 0x52d9;
  static constexpr Tagged_t kstackTraceLimit_string = 0x52ed;
  static constexpr Tagged_t kstatic_initializer_string = 0x5309;
  static constexpr Tagged_t ksticky_string = 0x5329;
  static constexpr Tagged_t kString_string = 0x533d;
  static constexpr Tagged_t kstring_string = 0x5351;
  static constexpr Tagged_t kstring_to_string = 0x5365;
  static constexpr Tagged_t ksuppressed_string = 0x5381;
  static constexpr Tagged_t kSuppressedError_string = 0x5399;
  static constexpr Tagged_t kSuspendError_string = 0x53b5;
  static constexpr Tagged_t kSymbol_iterator_string = 0x53cd;
  static constexpr Tagged_t kSymbol_match_all_string = 0x53e9;
  static constexpr Tagged_t kSymbol_replace_string = 0x5405;
  static constexpr Tagged_t ksymbol_species_string = 0x5421;
  static constexpr Tagged_t kSymbol_species_string = 0x543d;
  static constexpr Tagged_t kSymbol_split_string = 0x5459;
  static constexpr Tagged_t kSymbol_string = 0x5471;
  static constexpr Tagged_t ksymbol_string = 0x5485;
  static constexpr Tagged_t kSyntaxError_string = 0x5499;
  static constexpr Tagged_t ktarget_string = 0x54b1;
  static constexpr Tagged_t kthis_function_string = 0x54c5;
  static constexpr Tagged_t kthis_string = 0x54e1;
  static constexpr Tagged_t kthrow_string = 0x54f1;
  static constexpr Tagged_t ktimed_out_string = 0x5505;
  static constexpr Tagged_t ktimeZone_string = 0x551d;
  static constexpr Tagged_t ktimeZoneId_string = 0x5531;
  static constexpr Tagged_t ktimeZoneName_string = 0x5549;
  static constexpr Tagged_t ktoJSON_string = 0x5561;
  static constexpr Tagged_t ktoString_string = 0x5575;
  static constexpr Tagged_t ktrue_string = 0x5589;
  static constexpr Tagged_t ktotal_string = 0x5599;
  static constexpr Tagged_t kTypedArrayLength_string = 0x55ad;
  static constexpr Tagged_t kTypeError_string = 0x55d9;
  static constexpr Tagged_t kUint16Array_string = 0x55f1;
  static constexpr Tagged_t kUint32Array_string = 0x5609;
  static constexpr Tagged_t kUint8Array_string = 0x5621;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x5639;
  static constexpr Tagged_t kundefined_string = 0x5659;
  static constexpr Tagged_t kundefined_to_string = 0x5671;
  static constexpr Tagged_t kunicode_string = 0x5691;
  static constexpr Tagged_t kunicodeSets_string = 0x56a5;
  static constexpr Tagged_t kunit_string = 0x56bd;
  static constexpr Tagged_t kURIError_string = 0x56cd;
  static constexpr Tagged_t kUTC_string = 0x56e1;
  static constexpr Tagged_t kWeakMap_string = 0x56f1;
  static constexpr Tagged_t kWeakRef_string = 0x5705;
  static constexpr Tagged_t kWeakSet_string = 0x5719;
  static constexpr Tagged_t kweek_string = 0x572d;
  static constexpr Tagged_t kweeks_string = 0x573d;
  static constexpr Tagged_t kweekOfYear_string = 0x5751;
  static constexpr Tagged_t kwith_string = 0x5769;
  static constexpr Tagged_t kword_string = 0x5779;
  static constexpr Tagged_t kwritten_string = 0x5789;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x579d;
  static constexpr Tagged_t kyear_string = 0x57bd;
  static constexpr Tagged_t kyears_string = 0x57cd;
  static constexpr Tagged_t kyearOfWeek_string = 0x57e1;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x57f9;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5809;
  static constexpr Tagged_t kclass_fields_symbol = 0x5819;
  static constexpr Tagged_t kclass_positions_symbol = 0x5829;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5839;
  static constexpr Tagged_t kerror_message_symbol = 0x5849;
  static constexpr Tagged_t kerror_script_symbol = 0x5859;
  static constexpr Tagged_t kerror_stack_symbol = 0x5869;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5879;
  static constexpr Tagged_t kfrozen_symbol = 0x5889;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5899;
  static constexpr Tagged_t knative_context_index_symbol = 0x58a9;
  static constexpr Tagged_t knonextensible_symbol = 0x58b9;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x58c9;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x58d9;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x58e9;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x58f9;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5909;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5919;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5929;
  static constexpr Tagged_t ksealed_symbol = 0x5939;
  static constexpr Tagged_t kshared_struct_map_elements_template_symbol =
      0x5949;
  static constexpr Tagged_t kshared_struct_map_registry_key_symbol = 0x5959;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5969;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5979;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5989;
  static constexpr Tagged_t kwasm_asm_single_function_symbol = 0x5999;
  static constexpr Tagged_t kwasm_cross_instance_call_symbol = 0x59a9;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x59b9;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x59c9;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x59d9;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x59e9;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x59f9;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5a09;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5a39;
  static constexpr Tagged_t kmatch_symbol = 0x5a71;
  static constexpr Tagged_t ksearch_symbol = 0x5a99;
  static constexpr Tagged_t kunscopables_symbol = 0x5ac5;
  static constexpr Tagged_t kdispose_symbol = 0x5af5;
  static constexpr Tagged_t kasync_dispose_symbol = 0x5b21;
  static constexpr Tagged_t khas_instance_symbol = 0x5b51;
  static constexpr Tagged_t kto_string_tag_symbol = 0x5b81;
  static constexpr Tagged_t kconstructor_string = 0x5bf9;
  static constexpr Tagged_t knext_string = 0x5c11;
  static constexpr Tagged_t kresolve_string = 0x5c21;
  static constexpr Tagged_t kthen_string = 0x5c35;
  static constexpr Tagged_t kvalueOf_string = 0x5c45;
  static constexpr Tagged_t kiterator_symbol = 0x5c59;
  static constexpr Tagged_t kmatch_all_symbol = 0x5c69;
  static constexpr Tagged_t kreplace_symbol = 0x5c79;
  static constexpr Tagged_t kspecies_symbol = 0x5c89;
  static constexpr Tagged_t ksplit_symbol = 0x5c99;
  static constexpr Tagged_t kto_primitive_symbol = 0x5ca9;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x5cb9;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x5cc9;
  static constexpr Tagged_t kEmptySymbolTable = 0x5ced;
  static constexpr Tagged_t kUndefinedContextCell = 0x5d09;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x5d21;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x5d35;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x5d49;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x5d55;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x5d75;
  static constexpr Tagged_t kNativeScopeInfo = 0x5d99;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x5db1;
  static constexpr Tagged_t kManyClosuresCell = 0x5dc9;
  static constexpr Tagged_t kPreallocatedNumberStringTable = 0x5dd9;
  static constexpr Tagged_t kTheHoleValue = 0x6511;
  static constexpr Tagged_t kPropertyCellHoleValue = 0x6515;
  static constexpr Tagged_t kHashTableHoleValue = 0x6519;
  static constexpr Tagged_t kPromiseHoleValue = 0x651d;
  static constexpr Tagged_t kUninitializedValue = 0x6521;
  static constexpr Tagged_t kArgumentsMarker = 0x6525;
  static constexpr Tagged_t kTerminationException = 0x6529;
  static constexpr Tagged_t kException = 0x652d;
  static constexpr Tagged_t kOptimizedOut = 0x6531;
  static constexpr Tagged_t kStaleRegister = 0x6535;
  static constexpr Tagged_t kSelfReferenceMarker = 0x6539;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x653d;
  static constexpr Tagged_t kJSMessageObjectMap = 0x6541;
  static constexpr Tagged_t kExternalMap = 0x6569;
  static constexpr Tagged_t kCppHeapExternalMap = 0x6591;
  static constexpr Tagged_t kJSSharedArrayMap = 0x65b9;
  static constexpr Tagged_t kJSAtomicsMutexMap = 0x6601;
  static constexpr Tagged_t kJSAtomicsConditionMap = 0x6629;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x6651;

  static constexpr Tagged_t kFirstAllocatedRoot = 0x11;
  static constexpr Tagged_t kLastAllocatedRoot = 0x6651;
};

static constexpr std::array<Tagged_t, 1023> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kSeqOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kManyClosuresCell,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kHashTableHoleValue,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kPromiseHoleValue,
    StaticReadOnlyRoot::kPropertyCellHoleValue,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kAtomRegExpDataMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kContextCellMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kDictionaryTemplateInfoMap,
    StaticReadOnlyRoot::kDoubleStringCacheMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kIrRegExpDataMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kRegExpDataMap,
    StaticReadOnlyRoot::kRegExpMatchInfoMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kSimpleNameDictionaryMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kTrustedFixedArrayMap,
    StaticReadOnlyRoot::kTrustedWeakFixedArrayMap,
    StaticReadOnlyRoot::kTrustedByteArrayMap,
    StaticReadOnlyRoot::kProtectedFixedArrayMap,
    StaticReadOnlyRoot::kProtectedWeakFixedArrayMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kSharedFunctionInfoWrapperMap,
    StaticReadOnlyRoot::kTrustedForeignMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kSeqTwoByteStringMap,
    StaticReadOnlyRoot::kConsTwoByteStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kThinTwoByteStringMap,
    StaticReadOnlyRoot::kThinOneByteStringMap,
    StaticReadOnlyRoot::kSlicedTwoByteStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalTwoByteStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqTwoByteStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kHoleMap,
    StaticReadOnlyRoot::kJSSharedArrayMap,
    StaticReadOnlyRoot::kJSAtomicsMutexMap,
    StaticReadOnlyRoot::kJSAtomicsConditionMap,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kUndefinedNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kUndefinedContextCell,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kPreallocatedNumberStringTable,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfirstDayOfWeek_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kformatMatcher_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::klocaleMatcher_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kascii_nul_string,
    StaticReadOnlyRoot::kascii_soh_string,
    StaticReadOnlyRoot::kascii_stx_string,
    StaticReadOnlyRoot::kascii_etx_string,
    StaticReadOnlyRoot::kascii_eot_string,
    StaticReadOnlyRoot::kascii_enq_string,
    StaticReadOnlyRoot::kascii_ack_string,
    StaticReadOnlyRoot::kascii_bel_string,
    StaticReadOnlyRoot::kascii_bs_string,
    StaticReadOnlyRoot::kascii_ht_string,
    StaticReadOnlyRoot::kascii_lf_string,
    StaticReadOnlyRoot::kascii_vt_string,
    StaticReadOnlyRoot::kascii_ff_string,
    StaticReadOnlyRoot::kascii_cr_string,
    StaticReadOnlyRoot::kascii_so_string,
    StaticReadOnlyRoot::kascii_si_string,
    StaticReadOnlyRoot::kascii_dle_string,
    StaticReadOnlyRoot::kascii_dc1_string,
    StaticReadOnlyRoot::kascii_dc2_string,
    StaticReadOnlyRoot::kascii_dc3_string,
    StaticReadOnlyRoot::kascii_dc4_string,
    StaticReadOnlyRoot::kascii_nak_string,
    StaticReadOnlyRoot::kascii_syn_string,
    StaticReadOnlyRoot::kascii_etb_string,
    StaticReadOnlyRoot::kascii_can_string,
    StaticReadOnlyRoot::kascii_em_string,
    StaticReadOnlyRoot::kascii_sub_string,
    StaticReadOnlyRoot::kascii_esc_string,
    StaticReadOnlyRoot::kascii_fs_string,
    StaticReadOnlyRoot::kascii_gs_string,
    StaticReadOnlyRoot::kascii_rs_string,
    StaticReadOnlyRoot::kascii_us_string,
    StaticReadOnlyRoot::kspace_string,
    StaticReadOnlyRoot::kexclamation_mark_string,
    StaticReadOnlyRoot::kdouble_quotes_string,
    StaticReadOnlyRoot::khash_string,
    StaticReadOnlyRoot::kdollar_string,
    StaticReadOnlyRoot::kpercent_sign_string,
    StaticReadOnlyRoot::kampersand_string,
    StaticReadOnlyRoot::ksingle_quote_string,
    StaticReadOnlyRoot::kopen_parenthesis_string,
    StaticReadOnlyRoot::kclose_parenthesis_string,
    StaticReadOnlyRoot::kasterisk_string,
    StaticReadOnlyRoot::kplus_string,
    StaticReadOnlyRoot::kcomma_string,
    StaticReadOnlyRoot::kminus_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kslash_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::ktwo_string,
    StaticReadOnlyRoot::kthree_string,
    StaticReadOnlyRoot::kfour_string,
    StaticReadOnlyRoot::kfive_string,
    StaticReadOnlyRoot::ksix_string,
    StaticReadOnlyRoot::kseven_string,
    StaticReadOnlyRoot::keight_string,
    StaticReadOnlyRoot::knine_string,
    StaticReadOnlyRoot::kcolon_string,
    StaticReadOnlyRoot::ksemicolon_string,
    StaticReadOnlyRoot::kless_than_string,
    StaticReadOnlyRoot::kequals_string,
    StaticReadOnlyRoot::kgreater_than_string,
    StaticReadOnlyRoot::kquestion_mark_string,
    StaticReadOnlyRoot::kat_sign_string,
    StaticReadOnlyRoot::kA_string,
    StaticReadOnlyRoot::kB_string,
    StaticReadOnlyRoot::kC_string,
    StaticReadOnlyRoot::kD_string,
    StaticReadOnlyRoot::kE_string,
    StaticReadOnlyRoot::kF_string,
    StaticReadOnlyRoot::kG_string,
    StaticReadOnlyRoot::kH_string,
    StaticReadOnlyRoot::kI_string,
    StaticReadOnlyRoot::kJ_string,
    StaticReadOnlyRoot::kK_string,
    StaticReadOnlyRoot::kL_string,
    StaticReadOnlyRoot::kM_string,
    StaticReadOnlyRoot::kN_string,
    StaticReadOnlyRoot::kO_string,
    StaticReadOnlyRoot::kP_string,
    StaticReadOnlyRoot::kQ_string,
    StaticReadOnlyRoot::kR_string,
    StaticReadOnlyRoot::kS_string,
    StaticReadOnlyRoot::kT_string,
    StaticReadOnlyRoot::kU_string,
    StaticReadOnlyRoot::kV_string,
    StaticReadOnlyRoot::kW_string,
    StaticReadOnlyRoot::kX_string,
    StaticReadOnlyRoot::kY_string,
    StaticReadOnlyRoot::kZ_string,
    StaticReadOnlyRoot::kopen_bracket_string,
    StaticReadOnlyRoot::kbackslash_string,
    StaticReadOnlyRoot::kclose_bracket_string,
    StaticReadOnlyRoot::kcaret_string,
    StaticReadOnlyRoot::kunderscore_string,
    StaticReadOnlyRoot::kbacktick_string,
    StaticReadOnlyRoot::ka_string,
    StaticReadOnlyRoot::kb_string,
    StaticReadOnlyRoot::kc_string,
    StaticReadOnlyRoot::kd_string,
    StaticReadOnlyRoot::ke_string,
    StaticReadOnlyRoot::kf_string,
    StaticReadOnlyRoot::kg_string,
    StaticReadOnlyRoot::kh_string,
    StaticReadOnlyRoot::ki_string,
    StaticReadOnlyRoot::kj_string,
    StaticReadOnlyRoot::kk_string,
    StaticReadOnlyRoot::kl_string,
    StaticReadOnlyRoot::km_string,
    StaticReadOnlyRoot::kn_string,
    StaticReadOnlyRoot::ko_string,
    StaticReadOnlyRoot::kp_string,
    StaticReadOnlyRoot::kq_string,
    StaticReadOnlyRoot::kr_string,
    StaticReadOnlyRoot::ks_string,
    StaticReadOnlyRoot::kt_string,
    StaticReadOnlyRoot::ku_string,
    StaticReadOnlyRoot::kv_string,
    StaticReadOnlyRoot::kw_string,
    StaticReadOnlyRoot::kx_string,
    StaticReadOnlyRoot::ky_string,
    StaticReadOnlyRoot::kz_string,
    StaticReadOnlyRoot::kopen_brace_string,
    StaticReadOnlyRoot::kpipe_string,
    StaticReadOnlyRoot::kclose_brace_string,
    StaticReadOnlyRoot::ktilde_string,
    StaticReadOnlyRoot::kascii_del_string,
    StaticReadOnlyRoot::klatin1_80_string,
    StaticReadOnlyRoot::klatin1_81_string,
    StaticReadOnlyRoot::klatin1_82_string,
    StaticReadOnlyRoot::klatin1_83_string,
    StaticReadOnlyRoot::klatin1_84_string,
    StaticReadOnlyRoot::klatin1_85_string,
    StaticReadOnlyRoot::klatin1_86_string,
    StaticReadOnlyRoot::klatin1_87_string,
    StaticReadOnlyRoot::klatin1_88_string,
    StaticReadOnlyRoot::klatin1_89_string,
    StaticReadOnlyRoot::klatin1_8a_string,
    StaticReadOnlyRoot::klatin1_8b_string,
    StaticReadOnlyRoot::klatin1_8c_string,
    StaticReadOnlyRoot::klatin1_8d_string,
    StaticReadOnlyRoot::klatin1_8e_string,
    StaticReadOnlyRoot::klatin1_8f_string,
    StaticReadOnlyRoot::klatin1_90_string,
    StaticReadOnlyRoot::klatin1_91_string,
    StaticReadOnlyRoot::klatin1_92_string,
    StaticReadOnlyRoot::klatin1_93_string,
    StaticReadOnlyRoot::klatin1_94_string,
    StaticReadOnlyRoot::klatin1_95_string,
    StaticReadOnlyRoot::klatin1_96_string,
    StaticReadOnlyRoot::klatin1_97_string,
    StaticReadOnlyRoot::klatin1_98_string,
    StaticReadOnlyRoot::klatin1_99_string,
    StaticReadOnlyRoot::klatin1_9a_string,
    StaticReadOnlyRoot::klatin1_9b_string,
    StaticReadOnlyRoot::klatin1_9c_string,
    StaticReadOnlyRoot::klatin1_9d_string,
    StaticReadOnlyRoot::klatin1_9e_string,
    StaticReadOnlyRoot::klatin1_9f_string,
    StaticReadOnlyRoot::klatin1_a0_string,
    StaticReadOnlyRoot::klatin1_a1_string,
    StaticReadOnlyRoot::klatin1_a2_string,
    StaticReadOnlyRoot::klatin1_a3_string,
    StaticReadOnlyRoot::klatin1_a4_string,
    StaticReadOnlyRoot::klatin1_a5_string,
    StaticReadOnlyRoot::klatin1_a6_string,
    StaticReadOnlyRoot::klatin1_a7_string,
    StaticReadOnlyRoot::klatin1_a8_string,
    StaticReadOnlyRoot::klatin1_a9_string,
    StaticReadOnlyRoot::klatin1_aa_string,
    StaticReadOnlyRoot::klatin1_ab_string,
    StaticReadOnlyRoot::klatin1_ac_string,
    StaticReadOnlyRoot::klatin1_ad_string,
    StaticReadOnlyRoot::klatin1_ae_string,
    StaticReadOnlyRoot::klatin1_af_string,
    StaticReadOnlyRoot::klatin1_b0_string,
    StaticReadOnlyRoot::klatin1_b1_string,
    StaticReadOnlyRoot::klatin1_b2_string,
    StaticReadOnlyRoot::klatin1_b3_string,
    StaticReadOnlyRoot::klatin1_b4_string,
    StaticReadOnlyRoot::klatin1_b5_string,
    StaticReadOnlyRoot::klatin1_b6_string,
    StaticReadOnlyRoot::klatin1_b7_string,
    StaticReadOnlyRoot::klatin1_b8_string,
    StaticReadOnlyRoot::klatin1_b9_string,
    StaticReadOnlyRoot::klatin1_ba_string,
    StaticReadOnlyRoot::klatin1_bb_string,
    StaticReadOnlyRoot::klatin1_bc_string,
    StaticReadOnlyRoot::klatin1_bd_string,
    StaticReadOnlyRoot::klatin1_be_string,
    StaticReadOnlyRoot::klatin1_bf_string,
    StaticReadOnlyRoot::klatin1_c0_string,
    StaticReadOnlyRoot::klatin1_c1_string,
    StaticReadOnlyRoot::klatin1_c2_string,
    StaticReadOnlyRoot::klatin1_c3_string,
    StaticReadOnlyRoot::klatin1_c4_string,
    StaticReadOnlyRoot::klatin1_c5_string,
    StaticReadOnlyRoot::klatin1_c6_string,
    StaticReadOnlyRoot::klatin1_c7_string,
    StaticReadOnlyRoot::klatin1_c8_string,
    StaticReadOnlyRoot::klatin1_c9_string,
    StaticReadOnlyRoot::klatin1_ca_string,
    StaticReadOnlyRoot::klatin1_cb_string,
    StaticReadOnlyRoot::klatin1_cc_string,
    StaticReadOnlyRoot::klatin1_cd_string,
    StaticReadOnlyRoot::klatin1_ce_string,
    StaticReadOnlyRoot::klatin1_cf_string,
    StaticReadOnlyRoot::klatin1_d0_string,
    StaticReadOnlyRoot::klatin1_d1_string,
    StaticReadOnlyRoot::klatin1_d2_string,
    StaticReadOnlyRoot::klatin1_d3_string,
    StaticReadOnlyRoot::klatin1_d4_string,
    StaticReadOnlyRoot::klatin1_d5_string,
    StaticReadOnlyRoot::klatin1_d6_string,
    StaticReadOnlyRoot::klatin1_d7_string,
    StaticReadOnlyRoot::klatin1_d8_string,
    StaticReadOnlyRoot::klatin1_d9_string,
    StaticReadOnlyRoot::klatin1_da_string,
    StaticReadOnlyRoot::klatin1_db_string,
    StaticReadOnlyRoot::klatin1_dc_string,
    StaticReadOnlyRoot::klatin1_dd_string,
    StaticReadOnlyRoot::klatin1_de_string,
    StaticReadOnlyRoot::klatin1_df_string,
    StaticReadOnlyRoot::klatin1_e0_string,
    StaticReadOnlyRoot::klatin1_e1_string,
    StaticReadOnlyRoot::klatin1_e2_string,
    StaticReadOnlyRoot::klatin1_e3_string,
    StaticReadOnlyRoot::klatin1_e4_string,
    StaticReadOnlyRoot::klatin1_e5_string,
    StaticReadOnlyRoot::klatin1_e6_string,
    StaticReadOnlyRoot::klatin1_e7_string,
    StaticReadOnlyRoot::klatin1_e8_string,
    StaticReadOnlyRoot::klatin1_e9_string,
    StaticReadOnlyRoot::klatin1_ea_string,
    StaticReadOnlyRoot::klatin1_eb_string,
    StaticReadOnlyRoot::klatin1_ec_string,
    StaticReadOnlyRoot::klatin1_ed_string,
    StaticReadOnlyRoot::klatin1_ee_string,
    StaticReadOnlyRoot::klatin1_ef_string,
    StaticReadOnlyRoot::klatin1_f0_string,
    StaticReadOnlyRoot::klatin1_f1_string,
    StaticReadOnlyRoot::klatin1_f2_string,
    StaticReadOnlyRoot::klatin1_f3_string,
    StaticReadOnlyRoot::klatin1_f4_string,
    StaticReadOnlyRoot::klatin1_f5_string,
    StaticReadOnlyRoot::klatin1_f6_string,
    StaticReadOnlyRoot::klatin1_f7_string,
    StaticReadOnlyRoot::klatin1_f8_string,
    StaticReadOnlyRoot::klatin1_f9_string,
    StaticReadOnlyRoot::klatin1_fa_string,
    StaticReadOnlyRoot::klatin1_fb_string,
    StaticReadOnlyRoot::klatin1_fc_string,
    StaticReadOnlyRoot::klatin1_fd_string,
    StaticReadOnlyRoot::klatin1_fe_string,
    StaticReadOnlyRoot::klatin1_ff_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalphabet_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcalendarId_string,
    StaticReadOnlyRoot::kcalendarName_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kdisambiguation_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdisposed_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerror_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat16Array_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kgetTimeZoneTransition_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kinstance_members_initializer_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kIterator_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klast_chunk_handling_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kpromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kread_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kWebAssemblyModule_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksize_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::kstatic_initializer_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::ksuppressed_string,
    StaticReadOnlyRoot::kSuppressedError_string,
    StaticReadOnlyRoot::kSuspendError_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_match_all_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_split_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktimeZoneId_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypedArrayLength_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kwith_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kwritten_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kyearOfWeek_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_message_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kshared_struct_map_elements_template_symbol,
    StaticReadOnlyRoot::kshared_struct_map_registry_key_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_asm_single_function_symbol,
    StaticReadOnlyRoot::kwasm_cross_instance_call_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::kdispose_symbol,
    StaticReadOnlyRoot::kasync_dispose_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kBytecodeWrapperMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassBoilerplateMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kCodeWrapperMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kRegExpDataWrapperMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kStackTraceInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
    StaticReadOnlyRoot::kExternalMap,
    StaticReadOnlyRoot::kJSMessageObjectMap,
    StaticReadOnlyRoot::kCppHeapExternalMap,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_INTL_NOWASM_H_
