/*
 * mx-version
 *
 * Copyright 2010 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 * Boston, MA 02111-1307, USA.
 *
 */


#if !defined(MX_H_INSIDE) && !defined(MX_COMPILATION)
#error "Only <mx/mx.h> can be included directly.h"
#endif

/**
 * SECTION:mx-version
 * @short_description: Versioning utility macros
 *
 * Mx offers a set of macros for checking the version of the library
 * an application was linked to.
 */

#ifndef __MX_VERSION_H__
#define __MX_VERSION_H__

/**
 * MX_MAJOR_VERSION:
 *
 * The major version of the Mx clibrary (1 if version is 1.2.3)
 */
#define MX_MAJOR_VERSION              (1)

/**
 * MX_MINOR_VERSION:
 *
 * The minor version of the Mx library (2, if version is 1.2.3)
 */
#define MX_MINOR_VERSION              (2)

/**
 * MX_MICRO_VERSION:
 *
 * The micro version of the Mx library (3, if version is 1.2.3)
 */
#define MX_MICRO_VERSION              (1)

/**
 * MX_VERSION_S:
 *
 * The full version of the Mx library, in string form (suited for
 * string concatenation)
 */
#define MX_VERSION_S                  "1.2.1"

/**
 * MX_VERSION_HEX:
 *
 * Numerically encoded version of the Mx library, like 0x010203
 */
#define MX_VERSION_HEX                (MX_MAJOR_VERSION << 24 | \
                                         MX_MINOR_VERSION << 16 | \
                                         MX_MICRO_VERSION <<  8)
/**
 * MX_CHECK_VERSION:
 * @major: major version, like 1 in 1.2.3
 * @minor: minor version, like 2 in 1.2.3
 * @micro: micro version, like 3 in 1.2.3
 *
 * Evaluates to %TRUE if the version of the Mx library is greater
 * than @major, @minor and @micro
 */
#define MX_CHECK_VERSION(major,minor,micro)   \
        (MX_MAJOR_VERSION > (major) || \
         (MX_MAJOR_VERSION == (major) && MX_MINOR_VERSION > (minor)) || \
         (MX_MAJOR_VERSION == (major) && MX_MINOR_VERSION == (minor) && MX_MICRO_VERSION >= (micro)))

#endif /* __MX_VERSION_H__ */
